
function getNav4Layer(layerId, parent) 
{
  var objLayer;
  var parentObj = (parent)? parent : document;
  for (var i=0; i<parentObj.layers.length && !objLayer; i++) 
    {
      if(parentObj.layers[i].id == layerId) 
        {
          objLayer = parentObj.layers[i];
        }
      else 
        {
          objLayer = getNav4Layer(layerId, parentObj.layers[i]);
        }
    }
  return objLayer;
}

function CSSObject(name, obj)  
{
  if (client_std)  
    {
        this.name = name;
        if (typeof(obj)=='undefined')
          this.elem = document.getElementById(name);
        else
          this.elem = obj;
        if (this.elem!=null)
          this.css = this.elem.style;
    }
  else if(is_nav4)  
    {
        this.name = name;
        if (typeof(obj)=='undefined')
          this.elem = getNav4Layer(name, 0);
        else
          this.elem = obj;
        if (this.elem!=null)
          this.css = this.elem;
    }
  else if(is_ie4up)  
    {
        this.name = name;
        if (typeof(obj)=='undefined')
          this.elem = document.all[name];
        else
          this.elem = obj;
        if (this.elem!=null)
          this.css = this.elem.style;
    }
}

// ---- CSSObject.moveBy ------------
function moveByNav(x, y) 
{
  // this.elem.moveBy(x,y)
    this.css.left = parseInt(this.css.left) + x;
    this.css.top = parseInt(this.css.top) + y;
}
function moveByIE(x, y) 
{
    this.css.pixelLeft += x;
    this.css.pixelTop += y;
}
function moveByStd(x, y) 
{
    this.css.left = parseInt(this.css.left) + x + 'px';
    this.css.top = parseInt(this.css.top) + y + 'px';
}
if (client_std)
  CSSObject.prototype.moveBy = moveByStd
else if (is_nav4up)       
  CSSObject.prototype.moveBy = moveByNav
else if (is_ie4up)    
  CSSObject.prototype.moveBy = moveByIE;

// ---- CSSObject.moveTo ------------
function moveToNav(x, y) 
{
  // this.elem.moveTo(x,y)
    this.css.left = x;
    this.css.top = y;
}
function moveToIE(x, y) 
{
    this.css.pixelLeft = x;
    this.css.pixelTop = y;
}
function moveToStd(x, y) 
{
    this.css.left = x+'px';
    this.css.top = y+'px';
}
if (client_std)
  CSSObject.prototype.moveTo = moveToStd
else if (is_nav4up)       
  CSSObject.prototype.moveTo = moveToNav
else if (is_ie4up)    
  CSSObject.prototype.moveTo = moveToIE;

// ---- CSSObject.write ------------
// What follows only works with IE4 on Win (for css objects defined with <div>
// and not <span>), IE5 on both Win and Mac, Nav4, and Nav5.
function HTMLWriteNav4(html) 
{
    this.css.document.open();
    this.css.document.write(html);
    this.css.document.close();
}
function HTMLWriteIE5(html) 
{
    this.elem.innerHTML = html;
}
function HTMLWriteNav6(html) 
{
    var rng = document.createRange();
    rng.selectNodeContents(this.elem);
    rng.deleteContents();
    var htmlFrag = rng.createContextualFragment(html);
    this.elem.appendChild(htmlFrag);
}
if (is_nav4)         
  CSSObject.prototype.write = HTMLWriteNav4
else if (is_nav6up)    
  CSSObject.prototype.write = HTMLWriteNav6
else if (is_ie5up || (is_ie4 && is_win))
  CSSObject.prototype.write = HTMLWriteIE5;

// ---- CSSObject.getLeft ------------
function getLeftStd() 
{
  return parseInt(this.css.left);
}
function getLeftNav() 
{
  return this.css.left;
}
function getLeftIE() 
{
  return this.css.pixelLeft;
}
if (client_std)
  CSSObject.prototype.getLeft = getLeftStd;
else if (is_nav4up)       
  CSSObject.prototype.getLeft = getLeftNav;
else if (is_ie4up)    
  CSSObject.prototype.getLeft = getLeftIE;

// ---- CSSObject.getTop ------------
function getTopStd() 
{
  return parseInt(this.css.top);
}
function getTopNav() 
{
  return this.css.top;
}
function getTopIE() 
{
  return this.css.pixelTop;
}
if (client_std)
  CSSObject.prototype.getTop = getTopStd;
else if (is_nav4up)       
  CSSObject.prototype.getTop = getTopNav;
else if (is_ie4up)    
  CSSObject.prototype.getTop = getTopIE;

// ---- CSSObject.getRight ------------
function getRight() 
{
  return this.getLeft() + this.getWidth();
}
CSSObject.prototype.getRight = getRight;

// ---- CSSObject.getBottom ------------
function getBottom() 
{
  return this.getTop() + this.getHeight();
}
CSSObject.prototype.getBottom = getBottom;

// ---- CSSObject.getPageLeft ------------
function getPageLeftNav() 
{
  return this.elem.pageX;
}
function getPageLeftIE() 
{
  return this.elem.offsetLeft; 
}
if (is_nav4)       
  CSSObject.prototype.getPageLeft = getPageLeftNav;
else if (is_ie4up || is_nav6up)    
  CSSObject.prototype.getPageLeft = getPageLeftIE;

// ---- CSSObject.getPageTop ------------
function getPageLeftNav() 
{
  return this.elem.pageY;
}
function getPageTopIE() 
{
  return this.elem.offsetTop; 
}
if (is_nav4)       
  CSSObject.prototype.getPageTopt = getPageTopNav;
else if (is_ie4up || is_nav6up)    
  CSSObject.prototype.getPageTop = getPageTopIE;

// ---- CSSObject.getWidth ------------
function getWidthStd() 
{
  return(parseInt(this.css.width)); // .css.posWidth ??
}
function getWidthNav()  // elem.clip.width ??
{ 
  if (this.elem.document.width)
    return(this.elem.document.width);
  else
    return(this.elem.clip.right - this.elem.clip.left);
}
function getWidthIE()  // elem.offsetWidth ??
{
  if (this.css.pixelWidth)
    return(this.css.pixelWidth);
  else
    return(this.elem.clientWidth);
}
if (client_std)
  CSSObject.prototype.getWidth = getWidthStd;
else if (is_nav4up)       
  CSSObject.prototype.getWidth = getWidthNav;
else if (is_ie4up)    
  CSSObject.prototype.getWidth = getWidthIE

// ---- CSSObject.getHeight ------------
function getHeightStd()  // .css.posHeight ??
{
  return(parseInt(this.css.height));
}
function getHeightNav() // elem.clip.height ??
{
    if (this.elem.document.height)
      return(this.elem.document.height);
    else
      return(this.elem.clip.bottom - this.elem.clip.top);

}
function getHeightIE() // elem.offsetHeight ??
{
    if (false && this.css.pixelHeight)
      return(this.css.pixelHeight);
    else
      return(this.elem.clientHeight);
}
if (client_std)
  CSSObject.prototype.getHeight = getHeightStd;
else if (is_nav4up)       
  CSSObject.prototype.getHeight = getHeightNav;
else if (is_ie4up)    
  CSSObject.prototype.getHeight = getHeightIE

// ---- CSSObject.getzIndex ------------
function getzIndex() 
{
  return(this.css.zIndex);
}
CSSObject.prototype.getzIndex = getzIndex;

// ---- CSSObject.setzIndex ------------
function setzIndex(z) 
{
  this.css.zIndex = z;
}
CSSObject.prototype.setzIndex = setzIndex;

// ---- CSSObject.clipLayer ------------
function clipLayerNav(clipleft, cliptop, clipright, clipbottom)
{
    this.elem.clip.left   = clipleft;
    this.elem.clip.top    = cliptop;
    this.elem.clip.right  = clipright;
    this.elem.clip.bottom = clipbottom;
}
function clipLayerStd(clipleft, cliptop, clipright, clipbottom)
{
  this.css.clip = 'rect(' + cliptop + ' ' +  clipright + ' ' + clipbottom + ' ' + clipleft +')';
}
if (is_nav4)       
  CSSObject.prototype.clipLayer = clipLayerNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.clipLayer = clipLayerStd;

function getClipLeftNav() 
{
  return this.style.clip.left;
}
function getClipLeftStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[3]);
}
if (is_nav4)       
  CSSObject.prototype.getClipLeft = getClipLeftNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipLeft = getClipLeftStd;

function getClipTopNav() 
{
  return this.style.clip.top;
}
function getClipTopStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[0]);
}
if (is_nav4)       
  CSSObject.prototype.getClipTop = getClipTopNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipTop = getClipTopStd;

function getClipRightNav() 
{
  return this.style.clip.right;
}
function getClipRightStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[1]);
}
if (is_nav4)       
  CSSObject.prototype.getClipRight = getClipRightNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipRight = getClipRightStd;

function getClipBottomNav() 
{
  return this.style.clip.bottom;
}
function getClipBottomStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[2]);
}
if (is_nav4)       
  CSSObject.prototype.getClipBottom = getClipBottomNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipBottom = getClipBottomStd;

function getClipWidthNav() 
{
  return this.style.clip.width;
}
function getClipWidthStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[1]-clip[3]);
}
if (is_nav4)       
  CSSObject.prototype.getClipWidth = getClipWidthNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipWidth = getClipWidthStd;

function getClipHeightNav() 
{
  return this.style.clip.height;
}
function getClipHeightStd() 
{
  var str =  this.css.clip;
  if (!str)
    return(0);
  var clip = getClipValues(str);
  return(clip[2]-clip[0]);
}
if (is_nav4)       
  CSSObject.prototype.getClipHeight = getClipHeightNav;
else if (is_ie4up || client_std)    
  CSSObject.prototype.getClipHeight = getClipHeightStd;

function getClipValues(str) {

  var clip = new Array();
  var i;

  i = str.indexOf("(");
  clip[0] = parseInt(str.substring(i + 1, str.length), 10);
  i = str.indexOf(" ", i + 1);
  clip[1] = parseInt(str.substring(i + 1, str.length), 10);
  i = str.indexOf(" ", i + 1);
  clip[2] = parseInt(str.substring(i + 1, str.length), 10);
  i = str.indexOf(" ", i + 1);
  clip[3] = parseInt(str.substring(i + 1, str.length), 10);
  return(clip);
}

function scrollLayerTo(x, y, bound) {

  var dx = this.getClipLeft() - x;
  var dy = this.getClipTop() - y;

  this.scrollLayerBy(-dx, -dy, bound);
}
CSSObject.prototype.scrollLayerTo = scrollLayerTo;

function scrollLayerBy(dx, dy, bound) {

  var cl = this.getClipLeft();
  var ct = this.getClipTop();
  var cr = this.getClipRight();
  var cb = this.getClipBottom();

  if (bound) {
    if (cl + dx < 0)

      dx = -cl;

    else if (cr + dx > this.getWidth())
      dx = this.getWidth() - cr;
    if (ct + dy < 0)

      dy = -ct;

    else if (cb + dy > this.getHeight())
      dy = this.getHeight() - cb;
  }

  this.clipLayer( cl + dx, ct + dy, cr + dx, cb + dy);
  this.moveBy(-dx, -dy);
}
CSSObject.prototype.scrollLayerBy = scrollLayerBy;

function setBgColor(color) {

  if (is_nav4)
    this.css.bgColor = color;
  else if (is_ie4up)
    this.css.backgroundColor = color;
  else if (client_std)
    this.css.backgroundColor = color; // ?????     
}
CSSObject.prototype.setBgColor = setBgColor;

function setBgImage(src) {

  if (is_nav4)
    this.css.background.src = src;
  else if (is_ie4up)
    this.css.backgroundImage = "url(" + src + ")";
  else if (client_std)
    this.css.backgroundImage = "url(" + src + ")"; // ?????????????
}
CSSObject.prototype.setBgImage = setBgImage;

function getWindowWidth() {

  if (is_nav4)
    return(window.innerWidth);
  else if (is_ie4up)
    return(document.body.clientWidth);
  else if (client_std)
    return(document.body.clientWidth); // ???????????????
  return(-1);
}

function getWindowHeight() {

  if (is_nav4)
    return(window.innerHeight);
  else if (is_ie4up)
    return(document.body.clientHeight);
  else if (client_std)
    return(document.body.clientHeight); // ???????????????
  return(-1);
}

function getPageWidth() {

  if (is_nav4)
    return(document.width);
  else if (is_ie4up)
    return(document.body.scrollWidth);
  else if (client_std)
    return(document.body.scrollWidth); // ???????????????
  return(-1);
}

function getPageHeight() {

  if (is_nav4)
    return(document.height);
  else if (is_ie4up)
    return(document.body.scrollHeight);
  else if (client_std)
    return(document.body.scrollHeight); // ???????????????
  return(-1);
}

function getPageScrollX() {

  if (is_nav4)
    return(window.pageXOffset);
  else if (is_ie4up)
    return(document.body.scrollLeft);
  else if (client_std)
    return(document.body.scrollLeft); // ???????????????
  return(-1);
}

function getPageScrollY() {

  if (is_nav4)
    return(window.pageYOffset);
  else if (is_ie4up)
    return(document.body.scrollTop);
  else if (client_std)
    return(document.body.scrollTop); // ???????????????
  return(-1);
}

function hide() {

  if (is_nav4up)
    this.css.visibility = 'hide';
  else if (is_ie4up)
    this.css.visibility = 'hidden';
}
CSSObject.prototype.hide = hide;

function show() {

  if (is_nav4up)
    this.css.visibility = 'show';
  else if (is_ie4up)
    this.css.visibility = 'visible';
}
CSSObject.prototype.show = show;

function isVisible() {

  if (is_nav4up && this.css.visibility=='show')
    return true;
  if (is_ie4up && this.css.visibility=='visible')
    return true;
  return false;
}
CSSObject.prototype.show = show;

function insertAdjacentElement(elem, where,parsedNode)
{
  if (is_ie4up)
    {
      elem.insertAdjacentElement(where, parsedNode);
    }
  else if (is_nav6up)
    {
      switch (where){
      case 'beforeBegin':
          elem.parentNode.insertBefore(parsedNode,elem)
          break;
      case 'afterBegin':
          elem.insertBefore(parsedNode,elem.firstChild);
          break;
      case 'beforeEnd':
          elem.appendChild(parsedNode);
          break;
      case 'afterEnd':
          if (elem.nextSibling){
              elem.parentNode.insertBefore(parsedNode,elem.nextSibling);
          } else {
              elem.parentNode.appendChild(parsedNode)
          }
          break;
      }
    }
}

function insertAdjacentHTML(elem,where,htmlStr)
{
  if (is_ie4up)
    {
      if (where=='beforeEnd' && is_ie4)
        {
          // Insert HTML code at end of page. For IE4, need to scroll window to
          // end of page, insert and scroll back to correct bug.
          x = getPageScrollX();
          y = getPageScrollY();
          window.scrollTo(getPageWidth(), getPageHeight());
        }
      elem.insertAdjacentHTML(where, htmlStr);
      if (where=='beforeEnd' && is_ie4)
        window.scrollTo(x, y);        
    }
  else if (is_nav6up)
    {
      var r = elem.ownerDocument.createRange();
      r.setStartBefore(elem);
      var parsedHTML = r.createContextualFragment(htmlStr);
      elem.insertAdjacentElement(where,parsedHTML)
    }
}

function insertAdjacentText(elem,where,txtStr)
{
  if (is_ie4up)
    {
      elem.insertAdjacentText(where, txtStr);
    }
  else if (is_nav6up)
    {
      var parsedText = document.createTextNode(txtStr)
      elem.insertAdjacentElement(where,parsedText)
    }
}
